﻿//////////////////////////////////////////////
// ResourceSettingsChecker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class LogManager ;

	struct MapRequestDescriptor ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Buffers/Enums/BufferUsage.h"

#include "../Utils/DxDefinesWrapper.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class ResourceSettingsChecker
	{
		public :

			// Check whether the resource settings will allow its creation or not
			static bool checkResourceCreationSettings (BUFFER_USAGE usageFlag, unsigned int bindFlags, unsigned int cpuFlags, unsigned int miscFlags, void* cpuData, nkMemory::StringView resourceName, LogManager* logManager) ;

			// Check whether the settings allow a map of the resource or not
			static bool checkResourceMapCapacity (const MapRequestDescriptor& mapRequest, BUFFER_USAGE usageFlag, unsigned int cpuFlags, bool texture, nkMemory::StringView resourceName, LogManager* logManager) ;
			// Check whether the settings require a copy of the resource before mapping or not
			static bool resourceNeedsStagingMap (const MapRequestDescriptor& mapRequest, BUFFER_USAGE usageFlag, unsigned int cpuFlags, bool texture, nkMemory::StringView resourceName, LogManager* logManager) ;
	} ;
}